VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "GeneralConfigurationClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'///////////////////////////////////////////////////////////////////////////////
'//         General Configuration Class                                       //
'///////////////////////////////////////////////////////////////////////////////
'
' The General Configuration Class is used to hold configuration informationm
' used by the tracker.  This includes tracker configurations, tracker display
' configurations, and track series configurations.
'
' -----------------------------------------------------------------------------
' >> Needs Review and Testing
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Option Explicit
Option Compare Text

Private typeOfParameters As TypeOfConfiguration   ' The type of configuration info that is being stored
Private parameterSet As Scripting.Dictionary      ' All parameters are stored in this object

Const className = "GeneralConfigurationClass"

Private Sub Class_Initialize() ' OK
  
  On Error GoTo oops
  
  Set parameterSet = New Scripting.Dictionary   ' Values from the db are stored here
  parameterSet.CompareMode = TextCompare        ' Ignore upper and lower case
  typeOfParameters = unInitializedTC            ' The configuration hasn't been initialized yet
  
  Exit Sub
  
oops:
  StoreError
  ' This may or may not be a significant problem...  >> Caller should handle it.
  MyStoredError.Raise eSource:=className & ".Class_Initialize"
                        
End Sub

Public Function ReadFromDB(Optional dbToUse As Variant, _
                      Optional ByVal targetID As Variant, _
                      Optional rsToUse As Variant, _
                      Optional ByVal name As Variant, _
                      Optional ByVal ReadOnly As Boolean = False) As Boolean
  
  On Error GoTo oops
  Const methodeName = className & ".ReadFromDB"
  ReadFromDB = False
  
  Dim query As String           ' The SQL query
  Dim rs As ADODB.Recordset     ' The record set
  Dim db As DbConnectionClass   ' The db
  
  ' If no db was specified by the caller then use the parameter db by default.
  Set db = IIf(IsMissing(dbToUse), general.parametersDb, dbToUse)

  query = QueryForReadFromDB(IsMissing(targetID), IsMissing(name), targetID, name)
  Set rs = IIf(IsMissing(rsToUse), db.RecordSetOpen(query), rsToUse)
  If rs Is Nothing Then ' try to fix the problem
    If vbNo = IF_MsgBox("I couldn't find the " & TableName & " to read from. (I think it's missing.)" & vbCrLf & _
                      "would you like me to fix the problem by creating a default " & TableName & " table?", _
                      vbYesNo, "Table Missing", condition:=isVerbose, default:=vbYes) Then
      Err.Raise CANNOTCREATETABLE_ERROR, methodeName, MyStoredError.DescriptionOfError(CANNOTCREATETABLE_ERROR)
    Else
      If Not CreateMissingTable(db) Then
        Err.Raise CANNOTCREATETABLE_ERROR, methodeName, MyStoredError.DescriptionOfError(CANNOTCREATETABLE_ERROR)
      Else
        Set rs = db.RecordSetOpen(QueryForReadFromDB(True, False, -10, "default"))
      End If
    End If
  End If
  
  ' "No matching sonar parameter set in database."
  If rs.EOF Or rs.BOF Then ' NOTE - Need to break this out as a separate function to improve readability
    CreateDefaultRecord db
    Set rs = db.RecordSetOpen(QueryForReadFromDB(True, False, -10, "default"))
    If rs.EOF Or rs.BOF Then ' either the default record couldn't be created or it couldn't be read -> error!
      Dim identifier As String
          If IsMissing(name) Then
            identifier = targetID
          Else
            identifier = name
          End If
          
      Select Case Me.GetConfigType
        Case trackParametersTC, trackSeriesTC
          MsgBox "Was unable to find matching " & TableName & " parameters for " & _
                  IIf(IsMissing(name), TableName & "ID", "name") & " ='" & identifier & "'", _
                  vbOKOnly, "Please verify parameter/database settings and retry!"
        Case Else
          Err.Raise BADCONFIGTYPE_ERROR, className & methodeName, MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)
      End Select
      If IsMissing(rsToUse) Then db.RecordSetClose rs
      ReadFromDB = False
      Exit Function
    Else ' update the property list
      Select Case Me.GetConfigType
        Case trackParametersTC
          general.propertyList.SetProperty PropertyName, "default"
        Case trackSeriesTC ' do nothing - no action required
        Case Else
          Err.Raise BADCONFIGTYPE_ERROR, className & methodeName, MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)
      End Select
    End If
  End If
  
  parameterSet.RemoveAll ' Clean out the old parameters (if any) in the configuration
  
  Dim field As ADODB.field ' Capture the informations in the result's fields
  For Each field In rs.Fields
    If IsNull(field.value) Then Err.Raise UNEXPECTED_NULL_ERROR, _
        className & methodeName, MyStoredError.DescriptionOfError(UNEXPECTED_NULL_ERROR)
    parameterSet.Add field.name, field.value
  Next field

  If IsMissing(rsToUse) Then db.RecordSetClose rs
  ReadFromDB = True

  Exit Function

oops:
  Dim reply As VbMsgBoxResult
  StoreError
  Select Case MyStoredError.number
    Case BADCONFIGTYPE_ERROR
      ' let the function return failure / in developement stop at the assertion
      Debug.Assert (False)
      
    Case UNEXPECTED_NULL_ERROR  ' a null was read in from the DB - subst. a zero.
      field.value = "0"
      Resume Next
      
    Case CANNOTCREATETABLE_ERROR 'Couldn't create a "missing" table
      reply = MsgBox("An attempt to create a missing table in the database file failed." & vbCrLf & _
                    "Please make sure that the database file (" & db.GetFile & ")" & vbCrLf & _
                    "exists and is read/write enabled.", vbRetryCancel, "Data Base Error:")
      Select Case reply
        Case vbRetry
          Resume ' Try again.  Hopefully the problem could be fixed...
          
        Case vbCancel
          ' let the function return failure
          
        Case Else
          ' let the function return failure / in developement stop at the assertion
          Debug.Assert (False)
      End Select
                    
    Case Else ' unanticipated errors
      Debug.Assert (False)
  End Select
    
  ReadFromDB = False
  Exit Function
  
End Function

Public Function GetValue(ByVal key As String) As Variant ' OK
  
  On Error GoTo oops

  GetValue = parameterSet(key)
  If IsEmpty(GetValue) Then _
    Err.Raise UNKNOWN_ERROR, className & ".GetValue", MyStoredError.DescriptionOfError(UNKNOWN_ERROR)
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".GetValue"

End Function

Public Function Clone() As GeneralConfigurationClass ' ok

  On Error GoTo oops:
  
  Dim result As GeneralConfigurationClass
  Set result = New GeneralConfigurationClass
  result.Copy parameterSet, Me
  result.SetConfigType Me.GetConfigType
  
  Set Clone = result
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".Clone"
  
End Function

Public Sub Copy(sourceParameterSet As Scripting.Dictionary, _
                other As GeneralConfigurationClass) ' ok
  
  On Error GoTo oops
  
  If parameterSet.count <> 0 Then parameterSet.RemoveAll
  
  Dim names() As Variant
  names = sourceParameterSet.keys
  
  Dim i As Integer
  For i = 0 To UBound(names)
    parameterSet.Add names(i), sourceParameterSet(names(i))
  Next i

  Exit Sub
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".Copy"
  
End Sub

Public Sub SetValue(ByVal key As String, ByVal value As Variant) ' ok
  
  Debug.Assert (parameterSet.exists(key))
  Debug.Assert (TypeName(parameterSet(key)) = TypeName(value))
  
  ' need to preserve variable type
  On Error GoTo oops:
  
  If TypeName(parameterSet(key)) <> TypeName(value) Then
    Select Case TypeName(parameterSet(key)) ' to to make sure that I preserve variable type!
      Case "String"
        value = CStr(value)
      Case "Integer"
        value = CInt(value)
      Case "Long"
        value = CLng(value)
      Case "Double"
        value = CDbl(value)
      Case "Single"
        value = CSng(value)
      Case Else
        Debug.Assert (False)
      
    End Select
  End If

reentry:
5 If TypeName(value) = "String" Then value = SqlStrip(value)
  parameterSet(key) = value
  
  If value <> GetValue(key) Then _
      Err.Raise VALUE_NOT_SET_ERROR, className & ".SetValue", MyStoredError.DescriptionOfError(VALUE_NOT_SET_ERROR)

  Exit Sub
  
oops:
  Dim earl As String
  earl = Erl
  StoreError
  If earl = 0 Then Resume reentry:
  MyStoredError.Raise eSource:=className & ".SetValue"
  
End Sub

Public Function PrintAsRaw() As String ' ok

  ' This method is used by frmTrackExport to help generate its report on parameters
  On Error GoTo oops:
  
  Dim output As String
  Dim keys() As Variant
  Dim i As Integer
    
  keys = parameterSet.keys
  output = ""
    
  For i = 0 To UBound(keys)
    If parameterSet(keys(i)) <> "" Then _
      output = output & vbTab & keys(i) & " = " _
      & parameterSet(keys(i)) & vbCrLf
  Next i
    
  PrintAsRaw = output
  Exit Function
  
oops:
  StoreError
  PrintAsRaw = "Print method failed for this configuration."
  
End Function

Public Function GetConfigType() As TypeOfConfiguration  ' ok

    Debug.Assert (typeOfParameters >= unInitializedTC) And (typeOfParameters <= trackSeriesTC)
    GetConfigType = typeOfParameters

End Function

Public Sub SetConfigType(theType As TypeOfConfiguration)  ' ok
    
    Debug.Assert (theType >= unInitializedTC) And (theType <= trackSeriesTC)
    typeOfParameters = theType
  
End Sub

Public Function TypeWrong() As Boolean  ' ok

  ' return true if the type is wrong and false if it is ok
  On Error GoTo oops:
  
  Select Case GetConfigType
    Case trackParametersTC, trackSeriesTC 'trackdisplayTC,
      If parameterSet.exists(TableName & "ID") Then TypeWrong = False
    Case Else
      Err.Raise BADCONFIGTYPE_ERROR, className & "TypeWrong", _
                  MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)
  End Select
  
  Exit Function
oops:
  StoreError
  TypeWrong = True
  
End Function

Private Function QueryForReadFromDB(noID As Boolean, _
                                    noName As Boolean, _
                                    id As Variant, _
                                    name As Variant) As String ' ok
                                   
  ' This function returns the appropriate query for the ReadFromDB function
  On Error GoTo oops:
  
  Debug.Assert (noID <> noName)
  Dim query As String
  
  Select Case typeOfParameters
    Case trackParametersTC, trackSeriesTC ' trackdisplayTC,
      query = "select * FROM " & TableName & " where "
      If noName Then
        query = query & TableName & "ID= '" & id & "'"
      Else
        query = query & "name='" & name & "'"
      End If
           
    Case Else
      Err.Raise BADCONFIGTYPE_ERROR, className & ".QueryForReadFromDB", _
                                  MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)
  End Select

  QueryForReadFromDB = query
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".QueryForReadFromDB"
  
End Function

Public Function DeleteFromDB(name As String, Optional dbToUse As Variant) As Boolean ' ok
  
  On Error GoTo oops:
  
  Dim db As DbConnectionClass
  Dim rs As ADODB.Recordset
  
  ' If no database was specified, use the parameters database.
  
  If IsMissing(dbToUse) Then
    Set db = general.parametersDb
  Else
    Set db = dbToUse
  End If

  DeleteFromDB = False
  
  ' Delete by name is O.K. since names are (at least locally) unique
  
  On Error GoTo oops2: ' try to rollback...
  db.BeginTrans
  db.Execute "delete * from " & TableName & " where name='" & name & "'"
  db.CommitTrans
  
  DeleteFromDB = True
  
  Exit Function

oops:
  ErrorBox
  DeleteFromDB = False
  
  Exit Function
  
oops2:
  ErrorBox
  DeleteFromDB = False
  db.RollbackTrans
  
  Exit Function

End Function

Public Function SaveToDB(Optional ByVal connectionString As Variant, _
                    Optional dbToUse As Variant, _
                    Optional addDate As Boolean = True) As Boolean

  On Error GoTo oops:
  
  SaveToDB = False

  Dim db As DbConnectionClass
  Dim rs As ADODB.Recordset
  
  ' Set the creation date for the record
  If addDate Then Me.SetValue "creationDate", Date
      
  ' If no database was specified, save to the parameter database.
  Set db = IIf(IsMissing(dbToUse), general.parametersDb, dbToUse)
  ' Check for a record with the same name.
  
  Set rs = db.RecordSetOpen("select * from " & TableName)
  rs.Find "name='" & Me.GetValue("name") & "'"
 
  ' If there is a duplication, raise the name of the new record to a version number of up to 50.
  If Not (rs.EOF Or rs.BOF) Then
    Dim version As Integer
    Dim oldName As String
    Dim newName As String
    
    oldName = Me.GetValue("name")
    For version = 2 To 50
      newName = oldName & "_Version_" & Str(version)
      Set rs = db.RecordSetOpen("select * from " & TableName)
      rs.Find "name='" & newName & "'"
      If rs.EOF Or rs.BOF Then
        Me.SetValue "name", newName
          MsgBox "NOTE:  Duplicate names are not allowed." & _
                vbCrLf & "Your configuration has been saved as " & newName, vbOKOnly
        Exit For
      End If
    Next version
  End If
  
  Set rs = db.RecordSetOpen("select * from " & TableName)
  
  rs.Find "name='" & GetValue("name") & "'"
  
  Debug.Assert (rs.EOF)
  
  db.BeginTrans
  rs.AddNew ' Add a new record or overwrite an existing named configuration
  
  Dim field As ADODB.field
  Dim parameter As Collection

  For Each field In rs.Fields
    field = GetValue(field.name)
  Next field
  On Error GoTo 0
  
  rs.Update
  rs.Close
  
  db.CommitTrans
  SaveToDB = True
  
  Exit Function
  
oops:
  ErrorBox
  On Error GoTo oops2:
  db.RollbackTrans
  SaveToDB = False
  
  Exit Function
  
oops2:
  StoreError
  SaveToDB = False
  
  Exit Function

End Function

Private Function CreateMissingTable(db As DbConnectionClass) As Boolean ' ok

  ' This is meant to handle cases when the tracker tries to work with legacy
  ' databases.  This method creates to required table and then calls
  ' "CreateDefaultRecord" to create the initial default record.
  ' (A default record is needed so that the user can open the *form, in order to create
  ' or import new records.)
  '
  ' If "CreateMissingTable" is succesful it exits returning "true".
  
  On Error GoTo oops:
  CreateMissingTable = False
  
  Dim query As String
  query = CreateTableQuery
  
On Error GoTo oops2:
  db.BeginTrans
  db.Execute (query)
  CreateDefaultRecord db
  db.CommitTrans
  
  CreateMissingTable = True
  Exit Function
  
oops:
  StoreError
  CreateMissingTable = False
  Exit Function
  
oops2:
  StoreError
  On Error GoTo oops2:
  db.RollbackTrans
  CreateMissingTable = False

End Function

Private Function CreateTableQuery() As String ' ok

  ' This function generates the SQL query that is used by "CreateMissingTable"
  ' to create the appropriate missing table.
  
  On Error GoTo oops
  CreateTableQuery = "Failure"
  
  Dim query As String
  query = "CREATE TABLE "

  Select Case typeOfParameters
    Case trackParametersTC
      query = query & TableName & " (" _
                        & TableName & "ID TEXT(255), " _
                        & "name TEXT(50), " _
                        & "creationDate DATETIME, " _
                        & "createdBy TEXT(50), " _
                        & "description LONGTEXT, " _
                        & "tracker TEXT(50), " _
                        & "parameter1 TEXT(50), " _
                        & "parameter2 TEXT(50), " _
                        & "parameter3 TEXT(50), " _
                        & "parameter4 TEXT(50), " _
                        & "parameter5 TEXT(50), " _
                        & "parameter6 TEXT(50), " _
                        & "parameter7 TEXT(50), " _
                        & "parameter8 TEXT(50), " _
                        & "parameter9 TEXT(50), " _
                        & "parameter10 TEXT(50), " _
                        & " PRIMARY KEY (trackerConfigurationID)) "

    Case trackSeriesTC
      query = query & TableName & " (" _
                        & TableName & "ID TEXT(255), " _
                        & "pingSeriesID TEXT(50), " _
                        & "processedBy TEXT(50), " _
                        & "creationDate DATETIME, " _
                        & "softwareVersion TEXT(50), " _
                        & "name TEXT(50), " _
                        & "trackerConfigurationID TEXT(255), " _
                        & "trackerDisplayConfigurationID TEXT(255), " _
                        & " PRIMARY KEY (trackSeriesID)) "
                        
    Case unInitializedTC
      Debug.Assert (False)
      Exit Function
        
    Case Else
      Debug.Assert (False)
      Exit Function
  End Select
  
  CreateTableQuery = query
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".CreateTableQuery"
  
End Function

Public Function CreateDefaultRecord(db As DbConnectionClass) As Boolean
  
  ' This function creates the default record in the table created by "CreateMissingTable"
  ' Without a default record the user may not be able to open the configuration's
  ' settings form.
  '
  ' CreateDefaultRecord returns "true" iff. it is successful.
 
  On Error GoTo oops:
  CreateDefaultRecord = False
  
  Dim query As String
  Select Case typeOfParameters
    Case trackParametersTC
      query = "INSERT INTO " & TableName _
                & " (trackerConfigurationID, name, creationDate, createdBy, description," _
                & "tracker, parameter1, parameter2, parameter3, parameter4, parameter5," _
                & "parameter6, parameter7, parameter8, parameter9, parameter10" _
                & ") VALUES ('-10', 'default',  '6/21/2002', 'anon.', 'a default configuration'," _
                & "'0','0.3','0.4','2','not used','not used','not used','not used'," _
                & "'not used','not used','not used' )"
        
    Case trackSeriesTC
      query = "INSERT INTO " & TableName _
                & " (trackSeriesID, pingSeriesID, processedBy, creationDate," _
                & "softwareVersion, name, trackerConfigurationID, " _
                & "trackerDisplayConfigurationID" _
                & ") VALUES ('-10', 'none', 'anon', '" & Date _
                & "', '" & GetSoftwareVersion & "', 'default', 'not valid', 'not valid')"
                
    Case unInitializedTC
      Debug.Assert (False)
      Exit Function
        
    Case Else
      Debug.Assert (False)
      Exit Function
  End Select
  
On Error GoTo oops2:
  db.BeginTrans
  db.Execute (query)
  db.CommitTrans
    
  CreateDefaultRecord = True
  Exit Function
  
oops:
  StoreError
  CreateDefaultRecord = False
  Exit Function
  
oops2:
  StoreError
  On Error GoTo oops:
  db.RollbackTrans
  CreateDefaultRecord = False
  
End Function

Public Function DuplicateCount(Optional dbToUse As Variant, _
                                Optional withName As Variant, _
                                Optional withID As Variant, _
                                Optional notName As Boolean = False, _
                                Optional notID As Boolean = False) As Long
  
  ' Looks for records with the same name, and counts how many there are...

  On Error GoTo oops:
  
  Dim query As String
  Dim rs As ADODB.Recordset
  Dim count As Integer

  ' get query
  query = LookForDuplicate_GenerateSQL(withName, withID, notName, notID)
  
  ' set database
  Dim db As DbConnectionClass
  If IsMissing(dbToUse) Then
    Set db = general.parametersDb
  Else
    Set db = dbToUse
  End If
  
  If Not db.IsOpen Then db.dbOpen
  Set rs = db.Execute(query)
  
  Dim field As ADODB.field
  For Each field In rs.Fields
    Debug.Assert (Not IsNull(field.value)) ' STUB need to handle any NULL fields
    count = IIf(field.name = "Copies", field.value, -1)
  Next field
  
  rs.Close
  
  DuplicateCount = count
  
  Exit Function
  
oops:
  StoreError
  ErrorBox
  Dim prompt As String
  prompt = "I couldn't figure out how many duplicates exist of a profile" _
                & " in table " & TableName & vbCrLf & " of the db file (" & db.GetFile & ")" _
                & " Would you like to try to enter the correct the number?"
                
  If vbYes = MsgBox(prompt, vbYesNo, "Question Regarding Last Error:") Then
    prompt = "Please enter the number of records found. (positive whole numbers plaease)" & vbCrLf & _
             " the SQL query was: " & vbCrLf & vbCrLf & _
             query & vbCrLf & vbCrLf & "(Tip: You can open the db file in Access.)"
    count = InputBox(prompt, "Please Enter The Count")
    
    If count < 0 Or Not IsWholeNumber(count) Then MyStoredError.Raise
    DuplicateCount = count
  Else
    MyStoredError.Raise
  End If
     
End Function

Public Function GetNameOfDuplicate(Optional db As Variant) As String

  On Error GoTo oops:
  
  Dim count As Long
  Dim exists As Boolean
  Dim query As String
  Dim rs As ADODB.Recordset
  
  GetNameOfDuplicate = ""
  
  exists = (Me.DuplicateCount(db) > 0) ' checks for an exact duplicate...
  If exists Then
    GetNameOfDuplicate = Me.GetValue("name")
    Exit Function
  End If
  
  count = Me.DuplicateCount(db, , , notName:=True, notID:=True)
  If count > 0 Then
    query = LookForDuplicate_GenerateSQL(, , notName:=True, notID:=True)
    ' nead to trim front of query
    query = "Select name " & query
      
  End If
  
  Exit Function
  
oops:
  ErrorBox

End Function

Public Function LookForDuplicate_GenerateSQL(Optional withName As Variant, _
                                            Optional withID As Variant, _
                                            Optional notName As Boolean, _
                                            Optional notID As Boolean) As String

  ' LookForDuplicate_GenerateSQL() generates the desired sql query
  On Error GoTo oops:
  
  Dim index As Integer
  Dim parameterName As String
  Dim parameterNames() As Variant
  
  Dim conjunction As String
  Dim id As String
  Dim quotes As String
  Dim query As String
  
  conjunction = ""
  quotes = ""
  parameterNames = parameterSet.keys
  
  query = "SELECT COUNT(*) AS Copies FROM "     ' 1st part of select statment
  query = query & TableName
  query = query & " WHERE"

  For index = 0 To UBound(parameterNames)
    parameterName = parameterNames(index)
    If parameterName <> "name" And parameterName <> "description" And _
      parameterName <> "creationDate" And Not IsConfigurationID(parameterName) Then ' add a condition to the SQL query
        ' do I need to use quotes?
      quotes = IIf(TypeName(Me.GetValue(parameterName)) = "String", "'", "")  ' add the left hand side
      query = query & " " & conjunction & parameterName & " = " & quotes      ' add the right hand side
      Dim addStr As String
      addStr = Me.GetValue(parameterName) & quotes
      query = query & addStr
      conjunction = " AND "
    ElseIf IsConfigurationID(parameterName) Then
      id = parameterName
    End If
  Next index
  
  If Not IsMissing(withName) Then _
    query = query & " AND " & IIf(notName, " NOT", "") & " name = '" & withName & "'"
  If Not IsMissing(withID) Then _
    query = query & " AND " & IIf(notID, " NOT ", "") & id & " = '" & withID & "'"

  LookForDuplicate_GenerateSQL = query
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".LookForDuplicate_GenerateSQL"
  
End Function

Public Function TableName()
  
  On Error GoTo oops:
  
  Select Case typeOfParameters
    Case trackParametersTC
      TableName = "trackerConfiguration"
              
    Case trackSeriesTC
      TableName = "trackSeries"
    
    Case Else
      Err.Raise BADCONFIGTYPE_ERROR, className & ".TableName", MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)

  End Select
     
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".TableName"
  
End Function

Public Function LoadProfile(Form As Object) As Boolean

  On Error GoTo oops:
  LoadProfile = False
  
  Dim query As String
  Dim configurationName As String
  
  query = "select name, description from " & TableName & " order by creationDate"
  configurationName = frmDBOpenDialog.GetDbSelection(general.parametersDb, "name", query, _
        mustExist:=True, showDescription:=True, title:="Select a Configuration")
       
  If configurationName <> "" Then
    If ReadFromDB(name:=configurationName) Then
      With Form
        .FormFill
        .ConfigureControlProperties
        LoadProfile = True
      End With
    End If
  Else
    MsgBox "No configuration was chosen.  Try again."
    LoadProfile = True
  End If
  
  Exit Function
  
oops:
  StoreError
  LoadProfile = False
  
End Function

Public Function DeleteProfile(Form As Object)

  On Error GoTo oops
  
  Dim query As String
  Dim configurationName As String
  Dim reply As Integer
  
  reply = MsgBox("Do you really want to delete a configuration?", vbQuestion + vbYesNo, _
                  "Delete Profile?")
  If reply = vbNo Then Exit Function
    
  query = "select name, description from " & TableName & " where name <> 'default' order by creationDate"
  configurationName = frmDBOpenDialog.GetDbSelection( _
        general.parametersDb, "name", query, okButtonName:="Delete", mustExist:=True, _
        showDescription:=True, title:="Delete a Configuration")

  If configurationName <> "" Then
    If configurationName = Me.GetValue("name") And _
        Me.DeleteFromDB(configurationName) = True Then
      general.propertyList.SetProperty PropertyName, "default"
      Form.SetupForm
    End If
  Else
    MsgBox "No configuration was chosen.  Try again."
    DeleteProfile = True
  End If
  
  Exit Function
  
oops:
  StoreError
  DeleteProfile = False
  
End Function

Public Function PropertyName()

  On Error GoTo oops:
  
  Select Case typeOfParameters
    Case trackParametersTC
      PropertyName = "General:Tracker_Parameters"
    Case Else
      Err.Raise BADCONFIGTYPE_ERROR, className & ".PropertyName", MyStoredError.DescriptionOfError(BADCONFIGTYPE_ERROR)
  End Select
  
  Exit Function
  
oops:
  StoreError
  MyStoredError.Raise eSource:=className & ".PropertyName"
  
End Function

Public Function LastUsedProfile(Form As Object) As Boolean

  On Error GoTo oops:
  
  Dim profileName As String
  Dim testPassed As New GeneralConfigurationClass
    
  LastUsedProfile = False
  
  testPassed.SetConfigType Me.GetConfigType
  profileName = general.propertyList.GetProperty(PropertyName, defaultValue:="default")
  
  If testPassed.ReadFromDB(name:=profileName) Then
    If Form.ValidateProfile(testPassed) Then
      LastUsedProfile = Me.ReadFromDB(name:=profileName)
    Else
      MsgBox "Sorry, but I was unable to load the last used profile: " & profileName, , _
             "Unable To Load The Last Used Profile"
    End If
  Else
    MsgBox "Was unable to load the last used profile." & vbCrLf _
    & "There may be inconsistencies in the parameters database."
  End If
    
  Exit Function
  
oops:
  ErrorBox

End Function

Public Sub SaveAs(Form As Object, Optional dbTarget As Variant, _
                       Optional useDefaultName As Boolean = False)

  On Error GoTo oops:
  
  Dim query As String
  Dim name As String
  Dim db As DbConnectionClass
  
  Dim twinName As String
  ' check for a record that duplicates the one that the user is trying to save.
  twinName = GetNameOfDuplicate(dbTarget)
  If twinName <> "" Then
    MsgBox "There already is a profile with the same settings in the database." & vbCrLf _
          & "This profile is named '" & twinName & "'.", vbOKOnly, "Record Already Exists:"
    Me.SetValue "name", twinName
    Form.ConfigureControlProperties
    Exit Sub
  End If
  
  Set db = IIf(IsMissing(dbTarget), general.parametersDb, dbTarget)
      
  If Not useDefaultName Then ' Open browser so that user can save new settings
    query = "select name,description from " & TableName & " order by name"
    name = frmDBOpenDialog.GetDbSelection(db, _
          "name", query, "Save", OpenName:=name, _
          requireLeadingLetter:=True, showDescription:=True, title:="Save Configuration As")
    If name <> "" Then
      Me.SetValue TableName & "ID", GenerateUniqueID ' create a new ID for the new configuration
      Me.SetValue "name", name
    Else
      Exit Sub
    End If
  End If
  
  If Me.SaveToDB(dbToUse:=db) Then
    Form.ConfigureControlProperties
  Else
    MsgBox "Unable to save " & name & " (Sorry.)", , "Save Unsuccessful"
  End If
  
  Exit Sub
  
oops:
  ErrorBox

End Sub

Public Sub Apply(Form As Object, configToSet As Object)

0 On Error GoTo oops:
  
  If Form.modifiedSinceSave Then
    MsgBox "Please save your configuration" & vbCrLf & _
           "before attempting to apply it."
    Exit Sub
  End If
  
  If Not Form.ValidateProfile(Me) Then
    MsgBox "Was unable to apply the current configuration." & vbCrLf & _
           "The current configuration is invalid."
    Exit Sub
  End If
    
  Debug.Assert (Not Form.modifiedSinceSave)
  
5 Set configToSet = Me ' the configuration is applied
  general.propertyList.SetProperty PropertyName, Me.GetValue("name")
    
  Form.ConfigureControlProperties
  
  Exit Sub
  
oops:
  StoreError
  On Error GoTo oops2:
  Select Case Erl
    Case 0
      Resume Next
    Case Else
      ErrorBox
  End Select
  Exit Sub

oops2:
  ErrorBox
  
End Sub

Public Sub CloseForm(Form As Object)
    
  On Error GoTo oops:
  
  If Form.modifiedSinceSave Then
    If vbYes = MsgBox("Do you wish to save and apply the new settings?", _
                      vbQuestion + vbYesNo, "Apply Changes?") Then
      Form.mnuSaveAs_Click
      Form.mnuApplyProfile_Click
    End If
  ElseIf Form.NotApplied Then
    If vbYes = MsgBox("Do you wish apply the new settings?", _
                      vbQuestion + vbYesNo, "Apply Changes?") Then
      Form.mnuApplyParameters_Click
      End If
  End If
   
reentry:
  Form.Hide
  Unload Form
  
  Exit Sub
  
oops:
  ErrorBox
  On Error GoTo oops2:
  
  Resume reentry
 
oops2:
  MyStoredError.Raise eSource:=className & ".CloseForm"
  
End Sub

Public Function ValidateStandardFields() As Boolean

  Dim good As Boolean
  ValidateStandardFields = False
  
  On Error GoTo oops:
  
  ' check type
  good = Not TypeWrong
  
  If Not parameterSet.exists(TableName & "ID") Or _
         Not parameterSet.exists("description") Then
    ValidateStandardFields = False
    Exit Function
  End If
  
  ' check lengths of standard text fields
  good = good And TextFieldValid(Me.GetValue(TableName & "ID"), 1, 255)
  good = good And TextFieldValid(Me.GetValue("description"), 0, 511)
  good = good And IsDate(Me.GetValue("creationDate"))
  
  ValidateStandardFields = good

  Exit Function
  
oops:
  StoreError
  ValidateStandardFields = False
  
End Function

Public Function IsEquivalentTo(ByVal test As GeneralConfigurationClass) As Boolean
  
  Dim i As Integer
  Dim parameterName As String
  Dim parameterNames() As Variant
  Dim result As Boolean
  
  parameterNames = parameterSet.keys
  result = True
  For i = 0 To UBound(parameterNames)
    parameterName = parameterNames(i)
    If parameterName <> "name" And parameterName <> "description" And _
       parameterName <> "ConfigurationID" Then
       If Me.GetValue(parameterName) <> _
                              test.GetValue(parameterName) Then
        result = False
        Exit For
      End If
    End If
  Next i
  
  IsEquivalentTo = result
 
End Function

Public Sub Rename(Form As Object, Optional db As Variant)
  
  On Error GoTo oops
  
  Dim query As String
  Dim newName As String
  Dim toRename As GeneralConfigurationClass
  
  Set toRename = Me.Clone
  Set db = IIf(IsMissing(db), general.parametersDb, db)
  If vbYes <> MsgBox("Are you sure that you wish to rename the profile " _
          & Me.GetValue("name") & ".", vbYesNo, "Question?") Then Exit Sub
  
  query = "select name,description from " & TableName & " order by name"
  newName = frmDBOpenDialog.GetDbSelection(db, _
          "name", query, "Apply", OpenName:="Enter Name Here", _
          requireLeadingLetter:=True, title:="Renaming Profile:")
  
  If newName <> "" And newName <> "Enter Name Here" And newName <> "default" Then
    toRename.SetValue "name", newName
    
    db.BeginTrans
    If Not Me.DeleteFromDB(Me.GetValue("name"), dbToUse:=db) Then
      ' do something
      db.RollbackTrans
      Exit Sub
    Else
      If Not toRename.SaveToDB(dbToUse:=db, addDate:=False) Then
        ' do something
        db.RollbackTrans
        Exit Sub
      Else
        ' do nothing
      End If
    End If
    db.CommitTrans
    
    Me.SetValue "name", newName
    Form.ConfigureControlProperties
  Else
    MsgBox "No changes where made. (Sorry)" & vbCrLf & _
            "Please enter a legal profile name next time...", vbOKOnly, "Action Canceled:"
  End If
  Exit Sub
  
oops:
  ErrorBox
  db.RollbackTrans
  
End Sub
